package com.xforceplus.ant.coop.rule.center.client.api.cc;

import com.xforceplus.ant.coop.rule.center.client.data.cc.request.GetBizConfigDetail;
import com.xforceplus.ant.coop.rule.center.client.data.cc.request.ListBizConfigDetail;
import com.xforceplus.ant.coop.rule.center.client.data.cc.response.BizConfigDetail;
import com.xforceplus.ant.coop.rule.center.client.data.utils.BaseResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

/**
 * Describe: 业务配置对外读取配置 接口服务
 *
 * @Author xiezhongyong
 * @Date 2022/3/9
 */
@Api(value = "biz-template-dateils", description = "业务模板配置读取 接口服务")
public interface BizConfigOpenApi {


    @ApiOperation("业务模板配置详情---默认返回列表结构(get)")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "configType", value = "配置类型 0-购方配置(默认) 1-供应商配置 2-渠道商配置", dataType = "int", paramType = "query", defaultValue = "0"),
            @ApiImplicitParam(name = "configObjId", value = "配置方ID", dataType = "Long", paramType = "query", defaultValue = "0"),
            @ApiImplicitParam(name = "bindObjId", value = "关联对象ID", dataType = "Long", paramType = "query"),
            @ApiImplicitParam(name = "modelType", value = "模型类型", dataType = "int", paramType = "query", required = true),
            @ApiImplicitParam(name = "billTypeName", value = "业务单类型名称(有入参时必须存在当前业务单类型对应的模板，未匹配也不会返回通用模板)", dataType = "String", paramType = "query"),
            @ApiImplicitParam(name = "coopConfigClassId", value = "购方配置分类ID", dataType = "Long", paramType = "query"),
            @ApiImplicitParam(name = "configCode", value = "配置字段代码", dataType = "String", paramType = "query", required = true),
            @ApiImplicitParam(name = "commonFlag", value = "购方未配置时是否接受通用模板 0：接受（默认）；1：不接受", dataType = "int", paramType = "query", defaultValue = "0")}
    )
    @RequestMapping(value = "/open/biz-config", method = RequestMethod.GET, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<BizConfigDetail> getBizConfigDetail(@RequestParam(value = "configType", required = false, defaultValue = "0") Integer configType,
                                                   @RequestParam(value = "configObjId", required = false, defaultValue = "0") Long configObjId,
                                                   @RequestParam(value = "bindObjId", required = false) Long bindObjId,
                                                   @RequestParam(value = "modelType") Integer modelType,
                                                   @RequestParam(value = "billTypeName", required = false) String billTypeName,
                                                   @RequestParam(value = "coopConfigClassId", required = false) Long coopConfigClassId,
                                                   @RequestParam(value = "configCode") String configCode,
                                                   @RequestParam(value = "commonFlag", required = false, defaultValue = "0") Integer commonFlag);

    @ApiOperation("业务模板配置详情---默认返回列表结构(get,支持批量configCode获取)")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "configType", value = "配置类型 0-购方配置(默认) 1-供应商配置 2-渠道商配置", dataType = "int", paramType = "query", defaultValue = "0"),
            @ApiImplicitParam(name = "configObjId", value = "配置方ID", dataType = "Long", paramType = "query", defaultValue = "0"),
            @ApiImplicitParam(name = "bindObjId", value = "关联对象ID", dataType = "Long", paramType = "query"),
            @ApiImplicitParam(name = "modelType", value = "模型类型", dataType = "int", paramType = "query", required = true),
            @ApiImplicitParam(name = "billTypeName", value = "业务单类型名称(有入参时必须存在当前业务单类型对应的模板，未匹配也不会返回通用模板)", dataType = "String", paramType = "query"),
            @ApiImplicitParam(name = "coopConfigClassId", value = "购方配置分类ID", dataType = "Long", paramType = "query"),
            @ApiImplicitParam(name = "configCodes", value = "配置字段列表(多个逗号分割)", dataType = "List", paramType = "query", required = true),
            @ApiImplicitParam(name = "commonFlag", value = "购方未配置时是否接受通用模板 0：接受（默认）；1：不接受", dataType = "int", paramType = "query", defaultValue = "0")}
    )
    @RequestMapping(value = "/open/biz-configs", method = RequestMethod.GET, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<List<BizConfigDetail>> listBizConfigDetail(@RequestParam(value = "configType", required = false, defaultValue = "0") Integer configType,
                                                          @RequestParam(value = "configObjId", required = false, defaultValue = "0") Long configObjId,
                                                          @RequestParam(value = "bindObjId", required = false) Long bindObjId,
                                                          @RequestParam(value = "modelType") Integer modelType,
                                                          @RequestParam(value = "billTypeName", required = false) String billTypeName,
                                                          @RequestParam(value = "coopConfigClassId", required = false) Long coopConfigClassId,
                                                          @RequestParam(value = "configCodes") List<String> configCodes,
                                                          @RequestParam(value = "commonFlag", required = false, defaultValue = "0") Integer commonFlag);

    @ApiOperation("业务模板配置详情---默认返回列表结构(post)")
    @RequestMapping(value = "/open/template-config", method = RequestMethod.POST, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<BizConfigDetail> getBizConfigDetailPost(@RequestBody @Valid GetBizConfigDetail input);


    @ApiOperation("业务模板配置详情---默认返回列表结构(post,支持批量configCode获取)")
    @RequestMapping(value = "/open/template-configs", method = RequestMethod.POST, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<List<BizConfigDetail>> listBizConfigDetailPost(@RequestBody @Valid ListBizConfigDetail input);


}
