package com.xforceplus.ant.coop.rule.center.client.api.cc;

import com.xforceplus.ant.coop.rule.center.client.data.cc.response.ListCommonBizConfig;
import com.xforceplus.ant.coop.rule.center.client.data.utils.BaseResult;
import com.xforceplus.ant.coop.rule.center.client.data.utils.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * Describe: 通用业务配置 API
 *
 * @Author xiezhongyong
 * @Date 2020-03-26
 */
@Api(value = "common-biz-configs", description = "通用规则配置 接口服务", tags = {"业务配置相关业务-接口归类"})
public interface CommonBizConfigApi {

    @ApiOperation("通用配置列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "coopConfigId", value = "协同购方配置ID", dataType = "Long", paramType = "query", required = true),
            @ApiImplicitParam(name = "groupCode", value = "分组代码", dataType = "String", paramType = "query"),
            @ApiImplicitParam(name = "configCode", value = "配置代码(英文字段名,支持模糊查询)", dataType = "String", paramType = "query"),
            @ApiImplicitParam(name = "configName", value = "配置名称(中文字段名,支持模糊查询)", dataType = "String", paramType = "query")
    })
    @RequestMapping(value = "/common-biz-configs", method = RequestMethod.GET, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<Page<ListCommonBizConfig>> list(
            @SpringQueryMap Page page, @RequestParam(value = "coopConfigId") Long coopConfigId,
            @RequestParam(value = "groupCode", required = false) String groupCode,
            @RequestParam(value = "configCode", required = false) String configCode,
            @RequestParam(value = "configName", required = false) String configName);

}
