package com.xforceplus.ant.coop.rule.center.client.api.cc;

import com.xforceplus.ant.coop.rule.center.client.data.utils.BaseResult;
import com.xforceplus.ant.coop.rule.center.client.data.cc.response.ListCommonBizTemplate;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * Describe: 通用业务模板 API
 *
 * @Author xiezhongyong
 * @Date 2020-03-26
 */
@Api(value = "common-biz-templates", description = "通用规则模板 接口服务")
public interface CommonBizTemplateApi {

    @ApiOperation("通用模板列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "coopConfigId", value = "协同购方配置ID", dataType = "Long", paramType = "query", required = true),
            @ApiImplicitParam(name = "templateClassId", value = "模板分类ID", dataType = "Long", paramType = "query"),
            @ApiImplicitParam(name = "templateName", value = "模板名称(模糊查询)", dataType = "String", paramType = "query"),
            @ApiImplicitParam(name = "industryCode", value = "行业线(global-全局(默认值) coop-协同产品线 retail-零售 estate-地产)", dataType = "String", paramType = "query")
    })
    @RequestMapping(value = "/common-biz-templates",method = RequestMethod.GET, produces = { MediaType.APPLICATION_JSON_VALUE })
    BaseResult<List<ListCommonBizTemplate>> list(@RequestParam(value = "coopConfigId") Long coopConfigId,
                                                 @RequestParam(value = "templateClassId", required = false) Long templateClassId,
                                                 @RequestParam(value = "templateName", required = false) String templateName,
                                                 @RequestParam(value = "industryCode", required = false) String industryCode);

}
