package com.xforceplus.ant.coop.rule.center.client.api.cc;

import com.xforceplus.ant.coop.rule.center.client.data.utils.BaseResult;
import com.xforceplus.ant.coop.rule.center.client.data.cc.request.CreateDataTemplate;
import com.xforceplus.ant.coop.rule.center.client.data.cc.request.UpdateDataTemplateBillType;
import com.xforceplus.ant.coop.rule.center.client.data.cc.request.UpdateDataTemplateStatus;
import com.xforceplus.ant.coop.rule.center.client.data.cc.response.GetDataTemplate;
import com.xforceplus.ant.coop.rule.center.client.data.cc.response.ListDataTemplate;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

/**
 * Describe: 购方数据模板 API
 *
 * @Author xiezhongyong
 * @Date 2020-03-09
 */
@Api(value = "data-templates", description = "购方数据模板 接口服务")
public interface DataTemplateApi {


    @ApiOperation("数据模板列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "coopConfigId", value = "协同购方配置ID", dataType = "Long", paramType = "query", required = true),
            @ApiImplicitParam(name = "templateClassId", value = "模板分类ID", dataType = "Long", paramType = "query"),
            @ApiImplicitParam(name = "billTypeId", value = "业务单类型ID", dataType = "Long", paramType = "query"),
            @ApiImplicitParam(name = "templateCode", value = "模板代码", dataType = "String", paramType = "query"),
            @ApiImplicitParam(name = "configSource", value = "配置来源(0-规则中心(默认) 1-业务配置)", dataType = "Long", paramType = "query"),
            @ApiImplicitParam(name = "configGroupId", value = "业务配置分组ID", dataType = "Long", paramType = "query")}
    )
    @RequestMapping(value = "/data-templates",method = RequestMethod.GET, produces = { MediaType.APPLICATION_JSON_VALUE })
    BaseResult<List<ListDataTemplate>> list(@RequestParam(value = "coopConfigId") Long coopConfigId,
                                            @RequestParam(value = "templateClassId", required = false) Long templateClassId,
                                            @RequestParam(value = "billTypeId", required = false) Long billTypeId,
                                            @RequestParam(value = "templateCode", required = false) String templateCode,
                                            @RequestParam(value = "configSource", required = false) Integer configSource,
                                            @RequestParam(value = "configGroupId", required = false) Long configGroupId);

    @ApiOperation("获取数据模板详情")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "模板ID", required = true, dataType = "Long", paramType = "path")})
    @RequestMapping(value = "/data-templates/{id}",method = RequestMethod.GET, produces = { MediaType.APPLICATION_JSON_VALUE })
    BaseResult<GetDataTemplate> get(@PathVariable(value = "id") Long id);


    @ApiOperation("修改数据模板单据类型")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "模板ID", required = true, dataType = "Long", paramType = "path")})
    @RequestMapping(value = "/data-templates/{id}/bill-type",method = RequestMethod.PUT, produces = { MediaType.APPLICATION_JSON_VALUE })
    BaseResult<String> updateBillType(@PathVariable(value = "id") Long id, @RequestBody @Valid UpdateDataTemplateBillType input);

    @ApiOperation("修改数据模板状态")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "模板ID", required = true, dataType = "Long", paramType = "path")})
    @RequestMapping(value = "/data-templates/{id}/status",method = RequestMethod.PUT, produces = { MediaType.APPLICATION_JSON_VALUE })
    BaseResult<String> updateStatus(@PathVariable(value = "id") Long id, @RequestBody @Valid UpdateDataTemplateStatus input);


    @ApiOperation("添加数据模板")
    @RequestMapping(value = "/data-templates",method = RequestMethod.POST, produces = { MediaType.APPLICATION_JSON_VALUE })
    BaseResult<String> create(@RequestBody @Valid CreateDataTemplate input);

    @ApiOperation("删除数据模板")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "配置ID列表(不能为空,上限50)", required = true, dataType = "Long", paramType = "path")})
    @RequestMapping(value = "/data-templates/{ids}", method = RequestMethod.DELETE, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<String> delete(@PathVariable(value = "ids") List<Long> ids);

}
