package com.xforceplus.ant.coop.rule.center.client.api.cc;

import com.xforceplus.ant.coop.rule.center.client.data.utils.BaseResult;
import io.swagger.annotations.*;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;

/**
 * Describe: 模板导入
 *
 * @Author xiezhongyong
 * @Date 2020-04-21
 */
@Api(value = "template-import", description = "模板导入 接口服务")
public interface ImportTemplateApi {


    @ApiOperation("模板文件导入")
    @RequestMapping(value = "/import/template", method = RequestMethod.POST, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<String> importTemplate(@RequestParam("file") MultipartFile file, HttpServletRequest req);

    @ApiOperation("锁释放")
    @RequestMapping(value = "/import/releaselock", method = RequestMethod.GET, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<String> releaseLock();

}
