package com.xforceplus.ant.coop.rule.center.client.api.cc;

import com.xforceplus.ant.coop.rule.center.client.data.cc.request.GetRuleTemplateDetail;
import com.xforceplus.ant.coop.rule.center.client.data.cc.request.ListRuleTemplateDetail;
import com.xforceplus.ant.coop.rule.center.client.data.cc.response.RuleTemplateDetail;
import com.xforceplus.ant.coop.rule.center.client.data.utils.BaseResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;


/**
 * Describe: 规则模板配置读取
 *
 * @Author xiezhongyong
 * @Date 2020-04-14
 */
@Api(value = "rule-template-dateils", description = "规则模板配置读取 接口服务")
public interface RuleTemplateConfigApi {

    @ApiOperation("规则模板配置详情---默认返回列表结构")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "configType", value = "配置类型 0-购方配置(默认) 1-供应商配置 2-渠道商配置", dataType = "int", paramType = "query", defaultValue = "0"),
            @ApiImplicitParam(name = "configObjId", value = "配置方ID", dataType = "Long", paramType = "query", defaultValue = "0"),
            @ApiImplicitParam(name = "bindObjId", value = "关联对象ID", dataType = "Long", paramType = "query", defaultValue = "0"),
            @ApiImplicitParam(name = "modelType", value = "模型类型", dataType = "int", paramType = "query", required = true),
            @ApiImplicitParam(name = "billTypeName", value = "业务单类型名称(有入参时必须存在当前业务单类型对应的模板，未匹配也不会返回通用模板)", dataType = "String", paramType = "query"),
            @ApiImplicitParam(name = "coopConfigClassId", value = "购方配置分类ID", dataType = "Long", paramType = "query"),
            @ApiImplicitParam(name = "viewType", value = "返回数据结构类型 0：列表结构(默认)；1：分组结构", dataType = "int", paramType = "query", defaultValue = "0"),
            @ApiImplicitParam(name = "commonFlag", value = "购方未配置时是否接受通用模板 0：接受（默认）；1：不接受", dataType = "int", paramType = "query", defaultValue = "0")}
    )
    @RequestMapping(value = "/template-config/rule", method = RequestMethod.GET, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<RuleTemplateDetail> getRuleDetail(@RequestParam(value = "configType", required = false, defaultValue = "0") Integer configType,
                                                 @RequestParam(value = "configObjId", required = false, defaultValue = "0") Long configObjId,
                                                 @RequestParam(value = "bindObjId", required = false) Long bindObjId,
                                                 @RequestParam(value = "modelType") Integer modelType,
                                                 @RequestParam(value = "billTypeName", required = false) String billTypeName,
                                                 @RequestParam(value = "coopConfigClassId", required = false) Long coopConfigClassId,
                                                 @RequestParam(value = "viewType", required = false, defaultValue = "0") Integer viewType,
                                                 @RequestParam(value = "commonFlag", required = false, defaultValue = "0") Integer commonFlag,
                                                 @RequestParam(value = "sellerTaxNo", required = false) String sellerTaxNo,
                                                 @RequestParam(value = "purchaserTaxNo", required = false ) String purchaserTaxNo);

    @ApiOperation("规则模板配置详情---默认返回列表结构(POST)")
    @RequestMapping(value = "/template-config/rule", method = RequestMethod.POST, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<RuleTemplateDetail> getRuleDetailPost(@RequestBody @Valid GetRuleTemplateDetail getRuleTemplateDetail);


    @ApiOperation("规则模板配置详情(不支持单据类型，返回列表，购方未配置的情况下返回系统通过模板，反之不返回)---默认返回列表结构(POST)")
    @RequestMapping(value = "/template-config/rules", method = RequestMethod.POST, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<List<RuleTemplateDetail>> listRuleDetailPost(@RequestBody ListRuleTemplateDetail listRuleTemplateDetail);


    @ApiOperation("通过模板ID查询规则模板配置---默认返回列表结构")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "templateId", value = "数据模板ID", required = true, dataType = "Long", paramType = "path"),
            @ApiImplicitParam(name = "viewType", value = "返回数据结构类型 0:列表结构(默认)；1：分组结构", dataType = "int", paramType = "query", defaultValue = "0")})
    @RequestMapping(value = "/template-config/rule/{templateId}", method = RequestMethod.GET, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<RuleTemplateDetail> getRuleDetailById(@PathVariable(value = "templateId") Long dataTemplateId,
                                                     @RequestParam(value = "viewType", required = false, defaultValue = "0") Integer viewType);


}
