package com.xforceplus.ant.coop.rule.center.client.api.cc;

import com.xforceplus.ant.coop.rule.center.client.data.cc.request.BatchUpdateFieldSort;
import com.xforceplus.ant.coop.rule.center.client.data.utils.BaseResult;
import com.xforceplus.ant.coop.rule.center.client.data.cc.request.UpdateRuleTemplateItem;
import com.xforceplus.ant.coop.rule.center.client.data.cc.request.UpdateRuleTemplateItemField;
import com.xforceplus.ant.coop.rule.center.client.data.cc.response.*;
import io.swagger.annotations.*;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

/**
 * Describe: 规则模板明细 API
 *
 * @Author xiezhongyong
 * @Date 2020-03-09
 */
@Api(value = "rule-template-items", description = "规则模板明细 接口服务")
public interface RuleTemplateItemApi {

    @ApiOperation("规则模板明细 列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "templateId", value = "模板ID", dataType = "Long", paramType = "query", required = true)}
    )
    @RequestMapping(value = "/rule-template-items", method = RequestMethod.GET, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<List<ListRuleTemplateItem>> list(@RequestParam(value = "templateId") Long templateId);

    @ApiOperation("更新规则模板明细")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "item明细ID", required = true, dataType = "Long", paramType = "path")})
    @RequestMapping(value = "/rule-template-items/{id}", method = RequestMethod.PUT, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<String> updateTemplateItem(@PathVariable("id") Long id, @RequestBody @Valid UpdateRuleTemplateItem input);

    @ApiOperation("批量删除规则模板明细")
    @RequestMapping(value = "/rule-template-items/batch", method = RequestMethod.DELETE, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<String> batchDeleteTemplateItem(@RequestBody @ApiParam(name = "平台数据ID列表(格式：['1','2','3'])") List<Long> idList);

    @ApiOperation("获取规则模板明细 详情")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "item明细ID", required = true, dataType = "Long", paramType = "path")})
    @RequestMapping(value = "/rule-template-items/{id}", method = RequestMethod.GET, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<GetRuleTemplateItem> getTemplateItem(@PathVariable("id") Long id);

    @ApiOperation("规则模板添加字段 列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "templateId", value = "模板ID", dataType = "Long", paramType = "query", required = true)}
    )
    @RequestMapping(value = "/rule-template-items/fields", method = RequestMethod.GET, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<List<RuleTemplateField>> templateFields(@RequestParam(value = "templateId") Long templateId);


    @ApiOperation("更新规则模板字段")
    @RequestMapping(value = "/rule-template-items/fields", method = RequestMethod.PUT, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<String> updateTemplateFields(@RequestBody @Valid UpdateRuleTemplateItemField input);

    @ApiOperation("批量更新明细排序")
    @RequestMapping(value = "/rule-template-items/fields/sort", method = RequestMethod.PUT, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<String> batchUpdateFieldShowSort(@RequestBody @Valid BatchUpdateFieldSort input);
}
