package com.xforceplus.ant.coop.rule.center.client.api.enterprise;

import com.xforceplus.ant.coop.rule.center.client.data.enterprise.response.QualificationResult;
import com.xforceplus.ant.coop.rule.center.client.data.utils.BaseResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @author gaosheng
 * Created on 2022/6/30
 */
@Api(value = "qualification", description = "全电发票开具资质查询")
public interface QualificationApi {
    @ApiOperation("全电发票开具资质查询")
    @RequestMapping(value = "/taxware/invoice/all-electric/qualifications", method = RequestMethod.GET, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResponse<QualificationResult> queryAllElectricQualification(@RequestParam("tenantId") Long tenantId, @RequestParam("sellerTaxNo") String sellerTaxNo);
}
