package com.xforceplus.ant.coop.rule.center.client.api.sc;


import com.xforceplus.ant.coop.rule.center.client.data.sc.group.ListCommonConfigGroup;
import com.xforceplus.ant.coop.rule.center.client.data.utils.BaseResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * Describe: 通用业务配置分组
 *
 * @Author xiezhongyong
 * @Date 2022/5/11
 */
@Api(value = "common-config-groups", description = "通用业务配置分组 接口服务", tags = {"业务配置分组-接口归类"})
public interface CommonConfigGroupApi {

    @ApiOperation("通用配置分组列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "coopConfigId", value = "协同购方配置ID", dataType = "Long", paramType = "query", required = true),
            @ApiImplicitParam(name = "menuId", value = "菜单ID", dataType = "Long", paramType = "query", required = true)}
    )
    @RequestMapping(value = "/common-config-groups", method = RequestMethod.GET, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<List<ListCommonConfigGroup>> list(
            @RequestParam(value = "coopConfigId") Long coopConfigId,
            @RequestParam(value = "menuId") Long menuId);


}
