package com.xforceplus.ant.coop.rule.center.client.api.sc;

import com.xforceplus.ant.coop.rule.center.client.data.cc.request.*;
import com.xforceplus.ant.coop.rule.center.client.data.cc.response.ListBillType;
import com.xforceplus.ant.coop.rule.center.client.data.sc.group.*;
import com.xforceplus.ant.coop.rule.center.client.data.utils.BaseResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

/**
 * Describe: 业务配置分组
 *
 * @Author xiezhongyong
 * @Date 2022/5/11
 */
@Api(value = "config-groups", description = "业务配置分组 接口服务", tags = {"业务配置分组-接口归类"})
public interface ConfigGroupApi {

    @ApiOperation("配置分组列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "配置分组ID", dataType = "Long", paramType = "query"),
            @ApiImplicitParam(name = "coopConfigId", value = "协同购方配置分组ID", dataType = "Long", paramType = "query", required = true),
            @ApiImplicitParam(name = "menuId", value = "菜单ID", dataType = "Long", paramType = "query", required = true),
            @ApiImplicitParam(name = "status", value = "状态(1:启用,0:停用)", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "groupName", value = "分组名称(中文字段名,支持模糊查询)", dataType = "String", paramType = "query")}
    )
    @RequestMapping(value = "/config-groups", method = RequestMethod.GET, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<List<ListConfigGroup>> list(@RequestParam(value = "id", required = false) Long id,
                                           @RequestParam(value = "coopConfigId") Long coopConfigId,
                                           @RequestParam(value = "menuId") Long menuId,
                                           @RequestParam(value = "status", required = false) Integer status,
                                           @RequestParam(value = "groupName", required = false) String groupName);


    @ApiOperation("获取配置分组详情")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "配置分组ID", required = true, dataType = "Long", paramType = "path")})
    @RequestMapping(value = "/config-groups/{id}", method = RequestMethod.GET, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<GetConfigGroup> get(@PathVariable(value = "id") Long id);


    @ApiOperation("配置分组单据类型列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "配置分组ID", required = true, dataType = "Long", paramType = "path")})
    @RequestMapping(value = "/config-groups/{id}/bill-type", method = RequestMethod.GET, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<List<ListBillType>> listBillType(@PathVariable(value = "id") Long id);

    @ApiOperation("修改配置分组单据类型")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "配置分组ID", required = true, dataType = "Long", paramType = "path")})
    @RequestMapping(value = "/config-groups/{id}/bill-type", method = RequestMethod.PUT, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<String> updateBillType(@PathVariable(value = "id") Long id, @RequestBody @Valid UpdateConfigGroupBillType input);

    @ApiOperation("修改配置分组状态")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "配置分组ID", required = true, dataType = "Long", paramType = "path")})
    @RequestMapping(value = "/config-groups/{id}/status", method = RequestMethod.PUT, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<String> updateStatus(@PathVariable(value = "id") Long id, @RequestBody @Valid UpdateConfigGroupStatus input);


    @ApiOperation("修改配置分组限定条件(业务头部条件)")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "配置分组ID", required = true, dataType = "Long", paramType = "path")})
    @RequestMapping(value = "/config-groups/{id}/limiters", method = RequestMethod.PUT, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<String> updateLimiters(@PathVariable(value = "id") Long id, @RequestBody @Valid UpdateLimiters input);


    @ApiOperation("添加配置分组")
    @RequestMapping(value = "/config-groups", method = RequestMethod.POST, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<String> create(@RequestBody @Valid CreateConfigGroup input);

    @ApiOperation("删除配置分组")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "配置分组ID列表(不能为空,上限50)", required = true, dataType = "Long", paramType = "path")})
    @RequestMapping(value = "/config-groups/{ids}", method = RequestMethod.DELETE, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<String> delete(@PathVariable(value = "ids") List<Long> ids);


}
