package com.xforceplus.ant.coop.rule.center.client.api.sc;

import com.xforceplus.ant.coop.rule.center.client.data.sc.menu.ListTreeMenu;
import com.xforceplus.ant.coop.rule.center.client.data.sc.menu.SaveMenuConfig;
import com.xforceplus.ant.coop.rule.center.client.data.utils.BaseResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import java.util.List;

/**
 * Describe: 菜单配置
 *
 * @Author xiezhongyong
 * @Date 2022/4/29
 */
@Api(value = "menu-configs", description = "菜单配置 接口服务", tags = {"业务配置菜单-接口归类"})
public interface MenuConfigApi {


    @ApiOperation("配置方 树形菜单列表(仅返回已选择菜单列表)")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "coopConfigId", value = "协同购方配置ID", dataType = "Long", paramType = "query", required = true)}
    )
    @RequestMapping(value = "/menu-configs", method = RequestMethod.GET, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<List<ListTreeMenu>> listConfigTreeMenu(@RequestParam("coopConfigId") Long coopConfigId);

    @ApiOperation("通用 树形菜单列表(返回所有菜单列表)")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "coopConfigId", value = "协同购方配置ID", dataType = "Long", paramType = "query", required = true)}
    )
    @RequestMapping(value = "/menu-configs/common", method = RequestMethod.GET, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<List<ListTreeMenu>> listCommonTreeMenu(@RequestParam("coopConfigId") Long coopConfigId);

    @ApiOperation("配置方 菜单保存")
    @RequestMapping(value = "/menu-configs", method = RequestMethod.POST, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<String> saveMenuConfig(@RequestBody SaveMenuConfig input);


}
