package com.xforceplus.ant.coop.rule.center.client.data.canary.enums;

import java.util.Arrays;

/**
 * Describe: 灰度路由类型
 *
 * @Author xiezhongyong
 * @Date 2023/3/13 15:35
 */
public enum CanaryRouteTypeEnum {

    MIX_COOP("mix-canary", "协同融合灰度");
    private final String code;
    private final String message;

    CanaryRouteTypeEnum(String code, String message) {
        this.code = code;
        this.message = message;
    }

    public String code() {
        return code;
    }

    public String message() {
        return message;
    }


    public static CanaryRouteTypeEnum fromValue(String code) {
        return Arrays.stream(CanaryRouteTypeEnum.values())
                .filter(s -> s.code.equals(code))
                .findAny()
                .orElse(null);
    }
}
