package com.xforceplus.ant.coop.rule.center.client.data.canary.request;

import com.xforceplus.ant.coop.rule.center.client.data.canary.enums.CanaryConfigDataSourceEnum;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

/**
 * Describe: 智能匹配灰度数据添加
 *
 * @Author xiezhongyong
 * @Date 2021-11-11
 */
@Data
public class MindCanaryData {

    @NotNull(message = "销方公司ID 不能为空")
    @ApiModelProperty("销方公司ID")
    private Long sellerCompanyId;

    @NotEmpty(message = "销方公司名称 不能为空")
    @ApiModelProperty("销方公司名称")
    private String sellerCompanyName;

    @NotEmpty(message = "销方公司税号 不能为空")
    @ApiModelProperty("销方公司税号")
    private String sellerTax;

    @NotNull(message = "购方租户ID 不能为空")
    @ApiModelProperty("购方租户ID")
    private Long purchaserTenantId;

    @NotEmpty(message = "购方租户名称 不能为空")
    @ApiModelProperty("购方租户名称")
    private String purchaserTenantName;

    @ApiModelProperty("来源")
    private CanaryConfigDataSourceEnum sourceEnum = CanaryConfigDataSourceEnum.ENTER;
}
