package com.xforceplus.ant.coop.rule.center.client.data.canary.request;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import javax.validation.constraints.NotNull;
import java.util.Date;
import java.util.List;

/**
 * Describe: 关系协同关系登录时间
 *
 * @Author xiezhongyong
 * @Date 2021-11-02
 */
@Data
public class UpdateCoordinationLoginTime {

    @ApiModelProperty("登录信息列表")
    @NotNull(message = "登录信息列表不能为空")
    private List<LoginInfo> loginInfos;

    @Data
    public static class LoginInfo {
        @ApiModelProperty("公司ID")
        @NotNull(message = "公司ID不能为空")
        private Long companyId;
        @ApiModelProperty("公司名称")
        private String companyName;
        @ApiModelProperty("登录时间")
        private Date loginTime;
    }


}
