package com.xforceplus.ant.coop.rule.center.client.data.canary.response;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.ant.coop.rule.center.client.data.canary.request.SellerSelectConfig;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;

/**
 * Describe: 创建 灰度配置范围
 *
 * @Author xiezhongyong
 * @Date 2021-10-19
 */
@Data
public class GetCanaryConfigScope {
    @ApiModelProperty("数据ID")
    private String id;
    @ApiModelProperty("灰度配置ID")
    private String canaryConfigId;
    @ApiModelProperty("购方租户ID(0:全部购方)")
    private String purchaserTenantId;
    @ApiModelProperty("购方名称(购方选项)")
    private String purchaserTenantName;
    @ApiModelProperty("供应商筛选配置key ALL标识全部供应商")
    private String sellerSelectKey;
    @ApiModelProperty("供应商条件描述(销方选项)")
    private String sellerSelectDesc;
    @ApiModelProperty("供应商总数量(购方全部供应商数)")
    private Long totalSellerCount;
    @ApiModelProperty("供应商灰度数量(购方灰度供应商数量)")
    private Long canarySellerCount;
    @ApiModelProperty("全局供应商数量(全部供应商数)")
    private Long globalSellerCount;
    @ApiModelProperty("供应商灰度百分比(购方灰度占比)")
    private String canaryPercent;
    @ApiModelProperty("全局供应商占比(全局灰度占比)")
    private String globalCanaryPercent;

    @ApiModelProperty("配置范围类型 1:固定范围配置,2:增量范围配置")
    private Integer configScopeType;

    @ApiModelProperty("供应商筛选配置")
    private SellerSelectConfig sellerSelectConfig;
    @ApiModelProperty("供应商筛选配置(前端特供)")
    private JSONObject sellerSelectConfigExt;

    @ApiModelProperty("状态 0-启用(默认) 1-停用")
    private Integer status;
    @ApiModelProperty("创建时间")
    private String createTime;
    @ApiModelProperty("创建人")
    private String createUser;
    @ApiModelProperty("创建人姓名")
    private String createUserName;
    @ApiModelProperty("更新时间")
    private String updateTime;
    @ApiModelProperty("更新人")
    private String updateUser;
    @ApiModelProperty("更新人姓名")
    private String updateUserName;

}
