package com.xforceplus.ant.coop.rule.center.client.data.canary.response;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * Describe: 灰度协同关系 列表
 *
 * @Author xiezhongyong
 * @String 2021-10-21
 */
@Data
public class ListCanaryConfigData {
    @ApiModelProperty("数据ID")
    private String id;
    @ApiModelProperty("灰度配置ID")
    private String canaryConfigId;
    @ApiModelProperty("灰度配置名称")
    private String canaryConfigName;
    @ApiModelProperty("灰度配置代码")
    private String canaryCode;
    @ApiModelProperty("灰度配置范围ID")
    private String canaryConfigScopeId;
    @ApiModelProperty("销方公司id")
    private String sellerCompanyId;
    @ApiModelProperty("销方公司名称")
    private String sellerCompanyName;
    @ApiModelProperty("销方税号")
    private String sellerTax;
    @ApiModelProperty("购方租户ID")
    private String purchaserTenantId;
    @ApiModelProperty("购方租户名称")
    private String purchaserTenantName;
    @ApiModelProperty("灰度开始时间")
    private String canarySrartTime;
    @ApiModelProperty("数据类型 1:协同数据;2:通用数据")
    private Integer dataType;
    @ApiModelProperty("企业来源(1:协同中心;2:手动配置;3:定时器;4:excel导入)")
    private Integer source;
    @ApiModelProperty("状态 0-启用(默认) 1-停用")
    private Integer status;
    @ApiModelProperty("创建时间")
    private String createTime;
    @ApiModelProperty("创建人")
    private String createUser;
    @ApiModelProperty("创建人姓名")
    private String createUserName;
    @ApiModelProperty("更新时间")
    private String updateTime;
    @ApiModelProperty("更新人")
    private String updateUser;
    @ApiModelProperty("更新人姓名")
    private String updateUserName;
    @ApiModelProperty("供应商条件描述")
    private String sellerSelectDesc;
}
