package com.xforceplus.ant.coop.rule.center.client.data.cc.bean.fieldlimit;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Pattern;

/**
 * Describe: align-对齐方式
 *
 * @Author xiezhongyong
 * @Date 2020-03-27
 */
@Data
public class AlignLimit extends FieldLimit {

    @NotEmpty(message = "对齐方式 不能为空")
    @Pattern(regexp = "^-1$|^0$|^1$", message = "对齐方式 不合法")
    @ApiModelProperty("对齐方式 不合法(-1:左对齐;0:居中对齐，1:右对齐)")
    private String align;

}
