package com.xforceplus.ant.coop.rule.center.client.data.cc.bean.fieldlimit;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.Pattern;

/**
 * Describe: noShow-禁显项
 *
 * @Author xiezhongyong
 * @Date 2020-03-27
 */
@Data
public class NoShowLimit extends FieldLimit {
    @Pattern(regexp = "^0$|^1$", message = "状态 不合法")
    @ApiModelProperty("状态：0:启用;1:停用")
    private String status = "1";
    @Pattern(regexp = "^0$|^1$", message = "失效状态 不合法")
    @ApiModelProperty("失效状态：0:启用;1:停用")
    private String invalidStatus = "1";
    @ApiModelProperty("失效条件")
    private String invalidCondition;

}
