package com.xforceplus.ant.coop.rule.center.client.data.cc.bean.limiters;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;

/**
 * Describe: 条件组列表
 *
 * @Author xiezhongyong
 * @Date 2020-03-31
 */
@Data
public class Conditions {

    @Valid
    @NotNull(message = "条件组列表 不能为空[上限20]")
    @Size(min = 1, max = 20, message = "条件组列表数量范围[1-20]")
    @ApiModelProperty("条件组列表")
    private List<ConditionGroup> conditionGroups;

    @Pattern(message = "逻辑运算符 不合法", regexp = "^AND$|^OR$")
    @ApiModelProperty("逻辑运算符")
    private String logical = LogicalEnum.OR.code();

    /**
     * 条件组
     */

    @Data
    public static class ConditionGroup {
        @Size(min = 1, max = 20, message = "条件列表 不能为空[上限20]")
        @Valid
        @ApiModelProperty("条件列表")
        private List<ConditionItem> conditionItems = new ArrayList<>();


        @NotEmpty(message = "逻辑运算符 不能为空")
        @Pattern(message = "逻辑运算符 不合法", regexp = "^AND$|^OR$")
        @ApiModelProperty("逻辑运算符")
        private String logical /*= LogicalEnum.AND.code()*/;
    }

    /**
     * 条件明细
     */
    @Data
    public static class ConditionItem {
        @NotEmpty(message = "字段名 不能为空")
        @ApiModelProperty("字段名")
        private String fieldName;
        @NotEmpty(message = "字段中文名称 不能为空")
        @ApiModelProperty("字段中文名称")
        private String fieldDisplayName;
        @ApiModelProperty("字段类型 a-多文本 s-文本 n-数值 d-日期  t-时间  l-联想")
        @NotEmpty(message = "字段类型 不能为空")
        @Pattern(message = "字段类型 不合法", regexp = "^a$|^s$|^n$|^d$|^t$|^l$")
        private String fieldType;
        @ApiModelProperty("字段格式化")
        private String fieldFormat;
        @NotEmpty(message = "运算符 不能为空")
        @Pattern(message = "运算符 不合法", regexp = "^EQ$|^NE$|^GT$|^LT$|^GE|^LE$|^IS_EMPTY$|^NOT_EMPTY$|^LIKE$")
        @ApiModelProperty("运算符")
        private String operator;
        @ApiModelProperty("对比值")
        private String compareValue;
        //        @NotEmpty(message = "字段分组代码 不能为空")
        @ApiModelProperty("字段分组代码")
        private String fieldGroup;
        @ApiModelProperty("字段分组名称")
        private String fieldGroupName;
        //        @NotEmpty(message = "字段分组下标 不能为空")
        @ApiModelProperty("字段分组下标")
        private Integer fieldGroupIndex;
    }
}


