package com.xforceplus.ant.coop.rule.center.client.data.cc.bizconfig;

import lombok.Data;

import java.io.Serializable;

/**
 * Describe: 业务配置主信息
 *
 * @Author xiezhongyong
 * @Date 2022-04-02
 */
@Data
public class BizMainConfig implements Serializable {

    /**
     * 配置ID
     */
    private Long id;
    /**
     * 模型类型(类似模板层面归类)
     */
    private Integer modelType;

    /**
     * 协同配置ID
     */
    private Long coopConfigId;


    /**
     * 数据模板ID
     */
    private Long dataTemplateId;

    /**
     * 数据明细模板分组下标-0-默认值(可以同时选择主表明细)
     */
    private Integer dataItemGroupIndex;

    /**
     * 配置范围;0-购方配置(默认) 1-供应商配置 2-渠道商配置 10-通用
     */
    private Integer configScope;

    /**
     * 配置方ID
     */
    private Long configObjId;

    /**
     * 关联对象ID
     */
    private Long bindObjId;

    /**
     * 关联对象code
     */
    private String bindObjCode;

    /**
     * 关联对象名称
     */
    private String bindObjName;

    /**
     * 关联对象类型;1-租户(默认) 2-企业
     */
    private Integer bindObjType;

    /**
     * 继承标识;0-不允许继承 1-允许单继承(默认) 2-允许多继承
     */
    private Integer extendsFlag;

    /**
     * 单据类型ID
     */
    private Long billTypeId;

    /**
     * 适用范围;0-通用 1-限定条件
     */
    private Integer applyRange;

    /**
     * 限定条件开关;1-支持配置 0-不支持配置
     */
    private Integer limitersActive;

    /**
     * 限定条件MD5
     */
    private String limitersMd5;

    /**
     * 通用配置标记;0-否(默认) 1-是
     */
    private Integer commonFlag;

    /**
     * 配置来源;0-规则中心(默认) 1-业务配置
     */
    private Integer configSource;

    /**
     * 外层业务配置ID
     */
    private Long businessConfigId;

    /**
     * 父配置ID
     */
    private Long parentConfigId;

    /**
     * 配置代码(字段名)
     */
    private String configCode;

    /**
     * 配置名称
     */
    private String configName;

    /**
     * 配置类型
     */
    private String configType;

    /**
     * 配置描述
     */
    private String configDesc;

    /**
     * 条件开关;1-支持配置 0-不支持配置
     */
    private Integer conditionActive;

    /**
     * 条件类型;1-生效条件 0-失效条件
     */
    private Integer conditionType;

    /**
     * 条件状态;1-启用 0-停用
     */
    private Integer conditionStatus;


    /**
     * 分组代码
     */
    private String groupCode;

    /**
     * 分组名称
     */
    private String groupName;

    /**
     * 分组下标
     */
    private Integer groupIndex;

    /**
     * 配置优先级;0-通用模板 1-购方模板 2-业务配置
     */
    private Integer level;

    /**
     * 备注
     */
    private String remark;
}
