package com.xforceplus.ant.coop.rule.center.client.data.cc.bizconfig.conditioncheck.bean;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * Describe: 条件枚举对象
 *
 * @Author xiezhongyong
 * @Date 2022-06-02
 */
@Data
public class ConditionEnum {
    @NotEmpty(message = "字段名称 不能为空")
    @ApiModelProperty("字段名称")
    private String fieldName;

    @NotEmpty(message = "字段中文名称 不能为空")
    @ApiModelProperty("字段中文名称")
    private String fieldDisplayName;

    @Size(min = 1, max = 100, message = "可选操作符code列表 范围[1-100]")
    @ApiModelProperty("可选操作符code列表")
    private Set<String> operators = new HashSet<>();

    @Pattern(regexp = "^1$|^2$", message = "对比类型 不合法(1-文本框 2-下拉单选)")
    @NotEmpty(message = "对比类型 不能为空")
    @ApiModelProperty("对比类型(1-文本框 2-下拉单选)")
    private String compareType;

    @ApiModelProperty("对比下拉可选择项")
    private List<Option> compareOptions = new ArrayList<>();


    @ApiModelProperty("配置限制(-1:无限制,大于0表示具体出现次数限制)")
    private Integer limit = -1;

    @Data
    public static class Option {
        @ApiModelProperty("值/代码")
        private String code;
        @ApiModelProperty("描述")
        private String text;
    }
}
