package com.xforceplus.ant.coop.rule.center.client.data.cc.bizconfig.conditioncheck.enums;

import com.xforceplus.ant.coop.rule.center.client.data.cc.bizconfig.conditioncheck.bean.target.TolRangeTarget;
import com.xforceplus.ant.coop.rule.center.client.data.cc.bizconfig.enums.IEnum;

import java.util.Arrays;

/**
 * Describe: 校验类型
 *
 * @Author xiezhongyong
 * @Date 2022/6/2
 */
public enum CheckTypeEnum implements IEnum<String> {


    TOL_RANGE("tolRange", "枚举范围", TolRangeTarget.class);

    private final String code;
    private final String message;
    private final Class targetClass;

    CheckTypeEnum(String code, String message, Class targetClass) {
        this.code = code;
        this.message = message;
        this.targetClass = targetClass;
    }

    public String code() {
        return code;
    }

    public String message() {
        return message;
    }

    public Class targetClass() {
        return targetClass;
    }

    public static CheckTypeEnum fromValue(String code) {
        return Arrays.stream(CheckTypeEnum.values())
                .filter(s -> s.code.equals(code))
                .findAny()
                .orElse(null);
    }
}
