package com.xforceplus.ant.coop.rule.center.client.data.cc.bizconfig.multselect.enums;

import com.xforceplus.ant.coop.rule.center.client.data.cc.bizconfig.enums.IEnum;

import java.util.Arrays;

/**
 * Describe: 多选组件 选择性状态
 *
 * @Author xiezhongyong
 * @Date 2022/4/8
 */
public enum MultSelectStatusEnum implements IEnum<String> {


    ENABLED("1", "启用"),
    DISABLED("0", "停用");

    private final String code;
    private final String message;

    MultSelectStatusEnum(String code, String message) {
        this.code = code;
        this.message = message;
    }

    public String code() {
        return code;
    }

    public String message() {
        return message;
    }

    public static MultSelectStatusEnum fromValue(String code) {
        return Arrays.stream(MultSelectStatusEnum.values())
                .filter(s -> s.code.equals(code))
                .findAny()
                .orElse(null);
    }
}
