package com.xforceplus.ant.coop.rule.center.client.data.cc.bizconfig.tolRangeconfig.enums;

import com.xforceplus.ant.coop.rule.center.client.data.cc.bizconfig.enums.IEnum;

import java.util.Arrays;

/**
 * Describe: 容差配置-开关状态枚举配置
 *
 * @Author xiezhongyong
 * @Date 2022-03-07
 */
public enum TolRangeStatusEnum implements IEnum<String> {


    ENABLED("1", "启用"),
    DISABLED("0", "停用");

    private final String code;
    private final String message;

    TolRangeStatusEnum(String code, String message) {
        this.code = code;
        this.message = message;
    }

    public String code() {
        return code;
    }

    public String message() {
        return message;
    }

    public static TolRangeStatusEnum fromValue(String code) {
        return Arrays.stream(TolRangeStatusEnum.values())
                .filter(s -> s.code.equals(code))
                .findAny()
                .orElse(null);
    }
}
