package com.xforceplus.ant.coop.rule.center.client.data.cc.bizconfig.tolRangeconfig.enums;

import com.xforceplus.ant.coop.rule.center.client.data.cc.bizconfig.enums.IEnum;

import java.util.Arrays;

/**
 * Describe: 容差配置-容差单位
 * 0-固定金额（默认） 1-百分比
 * @Author xiezhongyong
 * @Date 2022-03-07
 */
public enum TolRangeUnitEnum implements IEnum<String> {


    FIXED_AMOUNT("0", "固定金额"),
    PERCENT("1", "百分比");

    private final String code;
    private final String message;

    TolRangeUnitEnum(String code, String message) {
        this.code = code;
        this.message = message;
    }

    public String code() {
        return code;
    }

    public String message() {
        return message;
    }

    public static TolRangeUnitEnum fromValue(String code) {
        return Arrays.stream(TolRangeUnitEnum.values())
                .filter(s -> s.code.equals(code))
                .findAny()
                .orElse(null);
    }
}
