package com.xforceplus.ant.coop.rule.center.client.data.cc.custtemplate;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.ant.coop.rule.center.client.data.cc.bean.FieldEnumValue;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;


/**
 * Describe: 导出模板配置 详情
 *
 * @Author xiezhongyong
 * @String 2021-05-31
 */
@Data
public class ExportTemplateDetail {

    @ApiModelProperty("数据ID")
    private String id;
    @ApiModelProperty("模板代码")
    private String templateCode;
    @ApiModelProperty("模板业务分类")
    private String businessType;
    @ApiModelProperty("模板名称")
    private String templateName;
    @ApiModelProperty("单据类型")
    private String billTypeName;
    @ApiModelProperty("字段明细")
    private List<ConfigItemGroup> itemGroups;



    /**
     * 分组对象
     */
    @Data
    public static class ConfigItemGroup {
        @ApiModelProperty("字段分组代码")
        private String fieldGroup;
        @ApiModelProperty("字段分组名称")
        private String fieldGroupName;
        @ApiModelProperty("字段分组下标")
        private Integer fieldGroupIndex;
        @ApiModelProperty("字段列表")
        private List<ConfigGroupItem> items;
    }
    @Data
    public static class ConfigGroupItem{

        @ApiModelProperty("数据ID")
        private String id;
        @ApiModelProperty("字段名")
        private String fieldName;
        @ApiModelProperty("字段中文名称")
        private String fieldDisplayName;
        @ApiModelProperty("字段类型 a-多文本 s-文本 n-数值 d-日期  t-时间  l-联想")
        private String fieldType;
        @ApiModelProperty("字段格式化")
        private String fieldFormat;
        @ApiModelProperty("字段显示顺序")
        private Integer fieldShowSort;
        @ApiModelProperty("字段限制类型(表示当前字段可修改的字段限制)")
        private String fieldLimitType;
        @ApiModelProperty("扩展字段标识 0-固定字段 1-扩展字段")
        private Integer extFalg;
        @ApiModelProperty("排序")
        private Integer sort;
        @ApiModelProperty("枚举值对象列表")
        private List<FieldEnumValue> fieldEnumValues;
        @ApiModelProperty("字段限制对象列表")
        private List<JSONObject> fieldLimits;
    }









}
