package com.xforceplus.ant.coop.rule.center.client.data.cc.custtemplate;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import java.util.List;

/**
 * Describe: 导出自定义 模板配置
 *
 * @Author xiezhongyong
 * @Date 2021-05-31
 */
@Data
public class UpdateExportTemplate {


    @ApiModelProperty("引用模板ID")
    private String refTemplateId;

    @ApiModelProperty("模板名称")
    private String templateName;

    @ApiModelProperty("默认模板标识 0-非默认 1-默认")
    @Pattern(regexp = "^0$|^1$", message = "默认模板标识 不合法")
    private String defaultFlag;


    @Valid
    @Size(min = 1, max = 500, message = "字段列表 范围值[1-500]")
    private List<CreateExportTemplate.FieldInfo> fieldList;


//    @Data
//    public static class FieldInfo{
//        @ApiModelProperty("字段名称")
//        @NotEmpty(message = "字段名称 不能为空")
//        private String fieldName;
//
//        @NotNull(message = "分组下标 不能为空")
//        private Integer groupIndex;
//    }


}
