package com.xforceplus.ant.coop.rule.center.client.data.cc.enums;


import java.util.Arrays;

/**
 * Describe: 对齐方式 不合法(-1:左对齐;0:居中对齐，1:右对齐)
 * @Author xiezhongyong
 * @Date 2021-06-01
 */
public enum AlignTypeEnum {

    LEFT("-1", "左对齐"),
    CENTER("0", "居中对齐"),
    RIGHT("1", "右对齐");

    private final String code;
    private final String message;

    AlignTypeEnum(String code, String message) {
        this.code = code;
        this.message = message;
    }

    public String code() {
        return code;
    }

    public String message() {
        return message;
    }

    public static AlignTypeEnum fromValue(Integer code) {
        return Arrays.stream(AlignTypeEnum.values())
                .filter(s -> s.code.equals(code))
                .findAny()
                .orElse(null);
    }
}
