package com.xforceplus.ant.coop.rule.center.client.data.cc.enums;

import java.util.Arrays;

/**
 * Describe: 规则配置 初始化状态
 *
 * @Author xiezhongyong
 * @Date 2022/5/7
 */
public enum CoopConfigInitStateEnum {

    UNDONE(0, "未完成配置初始化"),
    DONE(1, "已完成配置初始化");

    private final Integer code;
    private final String message;

    CoopConfigInitStateEnum(Integer code, String message) {
        this.code = code;
        this.message = message;
    }

    public Integer code() {
        return code;
    }

    public String message() {
        return message;
    }

    public static CoopConfigInitStateEnum fromValue(Integer code) {
        return Arrays.stream(CoopConfigInitStateEnum.values())
                .filter(s -> s.code.equals(code))
                .findAny()
                .orElse(null);
    }
}
