package com.xforceplus.ant.coop.rule.center.client.data.cc.enums.bizcfg;

import java.util.Arrays;

/**
 * Describe: 通用基础配置
 * 3004001	业务模板	commonBasicConfig	通用配置信息-配置模板	通用配置	3004001
 *
 * @Author xiezhongyong
 * @Date 2020-06-11
 */
public enum CommonBasicConfigEnum implements IBasicConfigEnum {

    @Deprecated
    ENTERPRISE_SERVICE_ORDER("enterpriseServiceOrder", "企业服务订购"),
    INVOICE_CE_BACKFILL_SOURCE_FILE("invoiceCeBackfillSourceFile", "电票回填源文件必填"),
    CONTACT_EMAIL_REQUIRED("contactEmailRequired", "联系人邮箱必填(启用:必填;停用:非必填[默认])"),
    INVOICE_CE_BACKFILL_SOURCE_FILE_SELECT("invoiceCeBackfillSourceFileSelect", "电子专票或电子普票回填时，必须上传电票配置文件选择"),
    BILL_TYPE_ENABLE_ALL_OPTION("billTypeEnableAllOption", "结算单查询单据类型支持全部选项"),

    ALL("ALL", "全部配置项"),
    UNDEFINED("", "未定义的配置项"),
    ;
    private Integer modelType = 3004001;
    private Long commonTemplateId = 3004001L;


    @Override
    public Integer modelType() {
        return modelType;
    }

    @Override
    public Long commonTemplateId() {
        return commonTemplateId;
    }

    private String code;
    private String message;


    CommonBasicConfigEnum(String code, String message) {
        this.code = code;
        this.message = message;
    }

    @Override
    public String code() {
        return this.code;
    }

    @Override
    public void code(String code) {
        this.code = code;
    }

    @Override
    public String message() {
        return this.message;
    }

    public static CommonBasicConfigEnum fromValue(String code) {
        CommonBasicConfigEnum anEnum = Arrays.stream(CommonBasicConfigEnum.values())
                .filter(s -> s.code.equals(code))
                .findAny()
                .orElse(null);
        if (null == anEnum) {
            UNDEFINED.code(code);
            return UNDEFINED;
        }
        return anEnum;
    }
}
