package com.xforceplus.ant.coop.rule.center.client.data.cc.enums.bizcfg;

import java.util.Arrays;

/**
 * Describe: 商品基础配置
 * 5001001	业务配置 goodsBasicConfig
 *
 * @Author xiezhongyong
 * @Date 2022-04-14
 */
public enum GoodsBasicConfigEnum implements IBasicConfigEnum {

    GOODS_PS_COORDINATION("goodsPsCoordination", "购销商品协同关系设置"),
    GOODS_PS_COORDINATION_PRIORITY("goodsPsCoordinationPriority", "购销商品协同匹配优先级设置"),

    ALL("ALL", "全部配置项"),
    UNDEFINED("", "未定义的配置项"),
    ;
    private Integer modelType = 5001001;
    private Long commonTemplateId = 5001001L;


    @Override
    public Integer modelType() {
        return modelType;
    }

    @Override
    public Long commonTemplateId() {
        return commonTemplateId;
    }

    private String code;
    private String message;


    GoodsBasicConfigEnum(String code, String message) {
        this.code = code;
        this.message = message;
    }

    @Override
    public String code() {
        return this.code;
    }

    @Override
    public void code(String code) {
        this.code = code;
    }

    @Override
    public String message() {
        return this.message;
    }

    public static GoodsBasicConfigEnum fromValue(String code) {
        GoodsBasicConfigEnum anEnum = Arrays.stream(GoodsBasicConfigEnum.values())
                .filter(s -> s.code.equals(code))
                .findAny()
                .orElse(null);

        if (null == anEnum) {
            UNDEFINED.code(code);
            return UNDEFINED;
        }
        return anEnum;
    }
}
