package com.xforceplus.ant.coop.rule.center.client.data.cc.enums.bizcfg;

import java.util.Arrays;

/**
 * Describe: 结算单基础配置
 * 3001001	业务模板	billBasicConfig	结算单基础-配置模板	结算单	3001001
 *
 * @Author xiezhongyong
 * @Date 2020-06-11
 */
public enum JzxBasicConfigEnum implements IBasicConfigEnum {

    JZX_PUR_ADJUST_PRICE_PERCENT("jzxPurAdjustPricePercent", "调价比例"),
    JZX_PUR_PRIC_METHOD("jzxPurPricMethod", "价格方式"),
    JZX_PUR_AUTO_CREATE_SELLER_BILL("jzxPurAutoCreateSellerBill", "是否自动生成销项业务单"),
    JZX_PUR_MODEL("jzxPurModel", "进转销模式"),



    ALL("ALL", "全部配置项"),
    UNDEFINED("", "未定义的配置项"),
    ;
    private Integer modelType = 6004001;
    private Long commonTemplateId = 6004001L;


    @Override
    public Integer modelType() {
        return modelType;
    }

    @Override
    public Long commonTemplateId() {
        return commonTemplateId;
    }

    private String code;
    private String message;


    JzxBasicConfigEnum(String code, String message) {
        this.code = code;
        this.message = message;
    }

    @Override
    public String code() {
        return this.code;
    }

    @Override
    public void code(String code) {
        this.code = code;
    }

    @Override
    public String message() {
        return this.message;
    }

    public static JzxBasicConfigEnum fromValue(String code) {
        JzxBasicConfigEnum anEnum = Arrays.stream(JzxBasicConfigEnum.values())
                .filter(s -> s.code.equals(code))
                .findAny()
                .orElse(null);

        if (null == anEnum) {
            UNDEFINED.code(code);
            return UNDEFINED;
        }
        return anEnum;
    }
}
