package com.xforceplus.ant.coop.rule.center.client.data.cc.enums.bizcfg;

import java.util.Arrays;

/**
 * Describe: 供应商发票基础配置
 * 3003002	业务模板	seller-invoice-config	发票基础-配置	发票	3003002
 *
 * @Author xiezhongyong
 * @Date 2020-08-18
 */
public enum SellerInvoiceBasicConfigEnum implements IBasicConfigEnum {

    COOP_INVOICE_OPENER_LOCK("coopInvoiceOpenerLock","发票开具后是否锁定"),

    ALL("ALL","全部配置项"),
    UNDEFINED("","未定义的配置项"),
    ;
    private Integer modelType = 3003002;
    private Long commonTemplateId = 3003002L;



    @Override
    public Integer modelType() {
        return modelType;
    }

    @Override
    public Long commonTemplateId() {
        return commonTemplateId;
    }

    private String code;
    private String message;


    SellerInvoiceBasicConfigEnum(String code, String message) {
        this.code = code;
        this.message = message;
    }

    @Override
    public String code() {
        return this.code;
    }

    @Override
    public void code(String code) {
        this.code = code;
    }

    @Override
    public String message() {
        return this.message;
    }

    public static SellerInvoiceBasicConfigEnum fromValue(String code) {
        SellerInvoiceBasicConfigEnum anEnum = Arrays.stream(SellerInvoiceBasicConfigEnum.values())
                .filter(s -> s.code.equals(code))
                .findAny()
                .orElse(null);
        if (null == anEnum) {
            UNDEFINED.code(code);
            return UNDEFINED;
        }
        return anEnum;
    }
}
