package com.xforceplus.ant.coop.rule.center.client.data.cc.enums.bizcfg;

import com.xforceplus.ant.coop.rule.center.client.data.cc.bizconfig.enums.BizConfigTypeEnum;

import java.util.Arrays;

/**
 * Describe: 微信消息通知-配置
 * 5001002	业务配置	wxMessageConfig
 *
 * @Author xiezhongyong
 * @Date 2020-07-29
 */
public enum WxMessageConfigEnum implements IBasicConfigEnum {

    /** 组件类型: ${@link BizConfigTypeEnum#BIZ_ITEM_01}*/
    PUR_BILL_ABANDON_MSG("purBillAbandonMsg", "购方作废结算单时，同步推送微信消息至供应商"),
    /** 组件类型: ${@link BizConfigTypeEnum#BIZ_ITEM_01}*/
    PUR_INVOICE_SIGN_MSG("purInvoiceSignMsg", "发票购方签收后，同步推送微信消息至供应商"),
    /** 组件类型: ${@link BizConfigTypeEnum#BIZ_ITEM_01}*/
    PUR_INVOICE_SCAN_MSG("purInvoiceScanMsg", "发票购方扫描后，同步推送微信消息至供应商"),
    /** 组件类型: ${@link BizConfigTypeEnum#BIZ_ITEM_01}*/
    PUR_INVOICE_AUDIT_MSG("purInvoiceAuditMsg", "发票购方审核后，同步推送微信消息至供应商"),
    /** 组件类型: ${@link BizConfigTypeEnum#BIZ_ITEM_01}*/
    PUR_INVOICE_AUTH_MSG("purInvoiceAuthMsg", "发票购方认证后，同步推送微信消息至供应商"),
    /** 组件类型: ${@link BizConfigTypeEnum#BIZ_ITEM_01}*/
    PUR_INVOICE_PAYMENT_MSG("purInvoicePaymentMsg", "发票购方付款后，同步推送微信消息至供应商"),

    ALL("ALL","全部配置项"),
    UNDEFINED("","未定义的配置项"),
    ;
    private Integer modelType = 5001002;
    private Long commonTemplateId = 5001002L;



    @Override
    public Integer modelType() {
        return modelType;
    }

    @Override
    public Long commonTemplateId() {
        return commonTemplateId;
    }

    private String code;
    private String message;


    WxMessageConfigEnum(String code, String message) {
        this.code = code;
        this.message = message;
    }

    @Override
    public String code() {
        return this.code;
    }

    @Override
    public void code(String code) {
        this.code = code;
    }

    @Override
    public String message() {
        return this.message;
    }

    public static WxMessageConfigEnum fromValue(String code) {
        WxMessageConfigEnum anEnum = Arrays.stream(WxMessageConfigEnum.values())
                .filter(s -> s.code.equals(code))
                .findAny()
                .orElse(null);
        if (null == anEnum) {
            UNDEFINED.code(code);
            return UNDEFINED;
        }
        return anEnum;
    }
}
