package com.xforceplus.ant.coop.rule.center.client.data.cc.request;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.ant.coop.rule.center.client.data.cc.bean.limiters.Conditions;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.Pattern;
import java.util.List;


/**
 * Describe: 购方业务模板配置明细修改
 *
 * @Author xiezhongyong
 * @Date 2020-04-02
 */
@Data
public class BatchUpdateBizTemplateCfgItem {

    @ApiModelProperty("模板ID")
    private Long templateId;

    @Pattern(regexp = "^0$|^1$", message = "适用范围 不合法")
    @ApiModelProperty("适用范围 0-通用 1-限定条件")
    private String applyRange;

    @Valid
    @ApiModelProperty("模板条件列表")
    private Conditions limiters;

    @Valid
    @ApiModelProperty("配置项列表")
    private List<Item> items;

    @Data
    public static class Item {
        @ApiModelProperty("数据ID")
        private Long id;

        @Pattern(regexp = "^0$|^1$", message = "字段值 不合法")
        @ApiModelProperty("字段值 0-启用 1-停用")
        private String fieldValue;

        @Pattern(regexp = "^0$|^1$", message = "条件状态 不合法")
        @ApiModelProperty("条件状态 0-停用 1-启用")
        private String conditionStatus;

        @Valid
        @ApiModelProperty("条件列表")
        private Conditions conditions;

        @ApiModelProperty("字段限制列表")
        private List<JSONObject> fieldLimits;

        @ApiModelProperty("更新内容配置（ FIELDVALUE,CONDITIONS,ALL）")
        private ItemUpdateFlag itemUpdateFlag = ItemUpdateFlag.ALL;

    }

    public enum ItemUpdateFlag{
        FIELDVALUE,CONDITIONS,ALL
    }
}
