package com.xforceplus.ant.coop.rule.center.client.data.cc.request;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.util.List;


/**
 * Describe: 批量更新数据模板明细sort,规则模板明细 fieldShowSort,业务模板筛选明细fieldShowSort 数据
 *
 * @Author xiezhongyong
 * @Date 2020-06-28
 */
@Data
public class BatchUpdateFieldSort {

    @NotNull(message = "模板ID 不能为空")
    @ApiModelProperty("模板ID")
    private Long templateId;

    @NotNull(message = "明细ID列表 不能为空")
    @Size(min = 1, max = 1000, message = "明细ID列表 范围值[1-1000]")
    @ApiModelProperty("明细ID列表")
    private List<Long> itemIds;

}
