package com.xforceplus.ant.coop.rule.center.client.data.cc.request;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Pattern;


/**
 * Describe: 创建  模板分类
 *
 * @Author xiezhongyong
 * @Date 2020-03-11
 */
@Data
public class CreateTemplateClass {

    @ApiModelProperty("数据id，如制定必须为数值")
    private String id;

    @ApiModelProperty("分类代码")
    private String classCode;

    @NotEmpty(message = "分类名称 不能为空")
    @ApiModelProperty("分类名称")
    private String className;

    @Pattern(regexp = "^0$|^1$", message = "业务单标记 不合法")
    @ApiModelProperty("业务单标记 0-通用配置(默认) 1-手动输入单据类型")
    private String billTypeFlag;

    @Pattern(regexp = "^0$|^1$|^2$|^3$", message = "编辑标记 不合法")
    @ApiModelProperty("编辑标记 0-可以编辑和删除 1-可编辑,不能删除 2-不可编辑,可以删除 3-不可编辑和删除")
    private String editFlag;

}
