package com.xforceplus.ant.coop.rule.center.client.data.cc.request;

import com.xforceplus.ant.coop.rule.center.client.data.cc.bean.limiters.Conditions;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

/**
 * Describe: 业务配置条件修改
 *
 * @Author xiezhongyong
 * @Date 2022-03-02
 */
@Data
public class UpdateBizConfigCondition {

    @NotEmpty(message = "条件状态 不能为空")
    @Pattern(regexp = "^0$|^1$", message = "条件状态 不合法")
    @ApiModelProperty("条件状态 0-停用 1-启用")
    private String conditionStatus;

    @Valid
    @ApiModelProperty("条件列表")
    private Conditions conditions;
}
