package com.xforceplus.ant.coop.rule.center.client.data.cc.request;

import com.xforceplus.ant.coop.rule.center.client.data.cc.bean.limiters.Conditions;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Pattern;

/**
 * Describe: 通用 限定条件修改请求
 *
 * @Author xiezhongyong
 * @Date 2022-03-02
 */
@Data
public class UpdateLimiters {

    @NotEmpty(message = "适用范围 不能为空")
    @Pattern(regexp =  "^0$|^1$", message = "适用范围 不合法")
    @ApiModelProperty("适用范围 0-通用 1-限定条件(当限定条件为空的实时传:0)")
    private String applyRange;

    @Valid
    @ApiModelProperty("限定条件列表")
    private Conditions limiters;
}
