package com.xforceplus.ant.coop.rule.center.client.data.cc.request.open;

import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Pattern;
import java.util.Objects;

/**
 * Describe: 同步 协同配置
 *
 * @Author xiezhongyong
 * @Date 2023/12/11 15:36
 */
public class SyncCoopConfigRequest {


    @NotEmpty(message = "配置方ID 不能为空")
    @ApiModelProperty("配置方ID(租户ID、企业ID 等)")
    private String configObjId;

    @NotEmpty(message = "配置方名称 不能为空")
    @ApiModelProperty("配置方名称")
    private String configObjName;

    @NotEmpty(message = "配置方code 不能为空")
    @ApiModelProperty("配置方code")
    private String configObjCode;

    @ApiModelProperty("配置类型 0-购方配置(默认) 1-供应商配置 2-渠道商配置")
    @Pattern(regexp = "^0$|^1$|^2$", message = "配置类型 不合法")
    private String configType = "0";

    @NotEmpty(message = "分类ID 不能为空")
    @ApiModelProperty("分类ID")
    private String coopConfigClassId = "1";


    public String getConfigObjId() {
        return configObjId;
    }

    public void setConfigObjId(String configObjId) {
        this.configObjId = configObjId;
    }

    public String getConfigObjName() {
        return configObjName;
    }

    public void setConfigObjName(String configObjName) {
        this.configObjName = configObjName;
    }

    public String getConfigObjCode() {
        return configObjCode;
    }

    public void setConfigObjCode(String configObjCode) {
        this.configObjCode = configObjCode;
    }

    public String getConfigType() {
        return configType;
    }

    public void setConfigType(String configType) {
        this.configType = configType;
    }

    public String getCoopConfigClassId() {
        return coopConfigClassId;
    }

    public void setCoopConfigClassId(String coopConfigClassId) {
        this.coopConfigClassId = coopConfigClassId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SyncCoopConfigRequest that = (SyncCoopConfigRequest) o;
        return Objects.equals(configObjId, that.configObjId) &&
                Objects.equals(configObjName, that.configObjName) &&
                Objects.equals(configObjCode, that.configObjCode) &&
                Objects.equals(configType, that.configType) &&
                Objects.equals(coopConfigClassId, that.coopConfigClassId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(configObjId, configObjName, configObjCode, configType, coopConfigClassId);
    }
}
