package com.xforceplus.ant.coop.rule.center.client.data.cc.response;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * Describe: 业务配置 列表
 *
 * @Author xiezhongyong
 * @String 2020-03-26
 */
@Data
public class ListCommonBizConfig {

    @ApiModelProperty("数据ID")
    private String id;

    @ApiModelProperty("模型类型(类似模板层面归类)")
    private Integer modelType;

    @ApiModelProperty("配置范围;0-购方配置(默认) 1-供应商配置 2-渠道商配置 10-通用")
    private Integer configScope;

    @ApiModelProperty("继承标识;0-不允许继承 1-允许单继承(默认) 2-允许多继承")
    private Integer extendsFlag;

    @ApiModelProperty("适用范围;0-通用 1-限定条件")
    private Integer applyRange;

    @ApiModelProperty("配置代码(字段名)")
    private String configCode;

    @ApiModelProperty("配置名称")
    private String configName;

    @ApiModelProperty("配置类型")
    private String configType;

    @ApiModelProperty("配置描述")
    private String configDesc;

    @ApiModelProperty("分组代码")
    private String groupCode;

    @ApiModelProperty("分组名称")
    private String groupName;

    @ApiModelProperty("分组下标")
    private Integer groupIndex;

    @ApiModelProperty("状态(停用配置无法被继承);1-启用(默认) 0-停用")
    private Integer status;

    @ApiModelProperty("编辑标记;0-可以编辑和删除 1-可编辑,不能删除 2-不可编辑,可以删除 3-不可编辑和删除")
    private Integer editFlag;

    @ApiModelProperty("添加标识 0-可以添加，1-已添加,不能再次添加")
    private Integer addFlag;
}
