package com.xforceplus.ant.coop.rule.center.client.data.cc.tool;

import com.xforceplus.ant.coop.rule.center.client.api.cc.ExportTemplateConfigApi;
import com.xforceplus.ant.coop.rule.center.client.data.cc.custtemplate.ExportTemplateDetail;
import com.xforceplus.ant.coop.rule.center.client.data.cc.enums.TcModelTypeEnum;
import com.xforceplus.ant.coop.rule.center.client.data.utils.BaseResult;
import com.xforceplus.xplatframework.exception.ResultCode;
import com.xforceplus.xplatframework.utils.JsonUtils;
import lombok.extern.slf4j.Slf4j;


/**
 * Describe: 导出模板处理工具类
 *
 * @Author xiezhongyong
 * @Date 2021-06-02
 */
@Slf4j
public class ExportTemplateConfigTool {


    /**
     *  读取供应商导出模板(查询模板不存在时会 返回购方租户的导出模板)
     * @param api
     * @param templateId 模板ID
     * @param bindObjId  关联ID(购方租户ID)
     * @param tcModelTypeEnum 模板类型
     * @param billTypeName 单据类型
     * @return
     */
    public static ExportTemplateDetail getExportDetail(ExportTemplateConfigApi api, Long templateId, Long bindObjId, TcModelTypeEnum tcModelTypeEnum, String billTypeName) {
        try {
            log.info("##### 导出模板查询入参: templateId:{}; bindObjId:{}; tcModelTypeEnum:{}; billTypeId:{}", templateId, bindObjId, tcModelTypeEnum, billTypeName);
            BaseResult<ExportTemplateDetail> response = api.getTemplateConfig(templateId, bindObjId, tcModelTypeEnum.code(), billTypeName);
            log.info("##### 导出模板查询响应: {}", JsonUtils.writeObjectToJson(response));

            if (ResultCode.SUCCESS.code().equals(response.getCode()) && null != response.getResult()) {
                return response.getResult();
            } else {
                throw new RuntimeException("导出模板查询响应 code!=1 或者result 为空");
            }

        }catch (Exception e) {
            log.error("##### 导出模板查询 异常：{}", e);
            throw e;
        }
    }

    /**
     *  读取供应商导出模板(查询模板不存在时会 返回购方租户的导出模板)
     * @param api
     * @param templateId 模板ID
     * @param bindObjId  关联ID(购方租户ID)
     * @param tcModelTypeEnum 模板类型
     * @return
     */
    public static ExportTemplateDetail getExportDetail(ExportTemplateConfigApi api, Long templateId, Long bindObjId, TcModelTypeEnum tcModelTypeEnum) {
        return getExportDetail(api, templateId, bindObjId, tcModelTypeEnum, null);
    }

}
