package com.xforceplus.ant.coop.rule.center.client.data.enterprise.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.Valid;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 设备的信息
 */
@ApiModel(description = "设备的信息")

@JsonInclude(NON_NULL)
public class DeviceQueryInfo implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("deviceType")
  private String deviceType = null;

  @JsonProperty("deviceTypeList")
  private List<String> deviceTypeList = new ArrayList<>();

  @JsonProperty("deviceIds")
  private List<Long> deviceIds = new ArrayList<>();

  @JsonProperty("deviceUns")
  private List<String> deviceUns = new ArrayList<>();

  @JsonProperty("originAccountTerminalId")
  private Long originAccountTerminalId = null;

  @JsonProperty("originAccountTerminalUn")
  private String originAccountTerminalUn = null;

  @JsonProperty("companyInfo")
  private CompanyQueryInfo companyInfo = null;

  @JsonProperty("deviceNo")
  private String deviceNo = null;

  @JsonProperty("deviceName")
  private String deviceName = null;

  @JsonProperty("supportService")
  private List<String> supportService = new ArrayList<>();

  @JsonProperty("status")
  private List<Integer> status = new ArrayList<>();

  @JsonProperty("taxDeviceInfo")
  private TaxDeviceQueryRequestInfo taxDeviceInfo = null;

  @JsonIgnore
  public DeviceQueryInfo deviceType(String deviceType) {
    this.deviceType = deviceType;
    return this;
  }

   /**
   * 设备类型，taxDevice：税控设备-税盘，taxControlKey:税控设备-税控钥匙/UKey
   * @return deviceType
  **/


  @ApiModelProperty(value = "设备类型，taxDevice：税控设备-税盘，taxControlKey:税控设备-税控钥匙/UKey")
  public String getDeviceType() {
    return deviceType;
  }

  public void setDeviceType(String deviceType) {
    this.deviceType = deviceType;
  }

  @JsonIgnore
  public DeviceQueryInfo deviceTypeList(List<String> deviceTypeList) {
    this.deviceTypeList = deviceTypeList;
    return this;
  }

  public DeviceQueryInfo addDeviceTypeListItem(String deviceTypeListItem) {
    this.deviceTypeList.add(deviceTypeListItem);
    return this;
  }

   /**
   * 设备类型，taxDevice：税控设备-税盘，taxControlKey:税控设备-税控钥匙/UKey
   * @return deviceTypeList
  **/


  @ApiModelProperty(value = "设备类型，taxDevice：税控设备-税盘，taxControlKey:税控设备-税控钥匙/UKey")
  public List<String> getDeviceTypeList() {
    return deviceTypeList;
  }

  public void setDeviceTypeList(List<String> deviceTypeList) {
    this.deviceTypeList = deviceTypeList;
  }

  @JsonIgnore
  public DeviceQueryInfo deviceIds(List<Long> deviceIds) {
    this.deviceIds = deviceIds;
    return this;
  }

  public DeviceQueryInfo addDeviceIdsItem(Long deviceIdsItem) {
    this.deviceIds.add(deviceIdsItem);
    return this;
  }

   /**
   * 设备id（已废弃，用deviceUns代替）
   * @return deviceIds
  **/


  @ApiModelProperty(value = "设备id（已废弃，用deviceUns代替）")
  public List<Long> getDeviceIds() {
    return deviceIds;
  }

  public void setDeviceIds(List<Long> deviceIds) {
    this.deviceIds = deviceIds;
  }

  @JsonIgnore
  public DeviceQueryInfo deviceUns(List<String> deviceUns) {
    this.deviceUns = deviceUns;
    return this;
  }

  public DeviceQueryInfo addDeviceUnsItem(String deviceUnsItem) {
    this.deviceUns.add(deviceUnsItem);
    return this;
  }

   /**
   * 设备唯一码
   * @return deviceUns
  **/


  @ApiModelProperty(value = "设备唯一码")
  public List<String> getDeviceUns() {
    return deviceUns;
  }

  public void setDeviceUns(List<String> deviceUns) {
    this.deviceUns = deviceUns;
  }

  @JsonIgnore
  public DeviceQueryInfo originAccountTerminalId(Long originAccountTerminalId) {
    this.originAccountTerminalId = originAccountTerminalId;
    return this;
  }

   /**
   * 底账服务器终端id（已废弃，用originAccountTerminalUn代替）
   * @return originAccountTerminalId
  **/


  @ApiModelProperty(value = "底账服务器终端id（已废弃，用originAccountTerminalUn代替）")
  public Long getOriginAccountTerminalId() {
    return originAccountTerminalId;
  }

  public void setOriginAccountTerminalId(Long originAccountTerminalId) {
    this.originAccountTerminalId = originAccountTerminalId;
  }

  @JsonIgnore
  public DeviceQueryInfo originAccountTerminalUn(String originAccountTerminalUn) {
    this.originAccountTerminalUn = originAccountTerminalUn;
    return this;
  }

   /**
   * 底账服务器终端唯一码
   * @return originAccountTerminalUn
  **/


  @ApiModelProperty(value = "底账服务器终端唯一码")
  public String getOriginAccountTerminalUn() {
    return originAccountTerminalUn;
  }

  public void setOriginAccountTerminalUn(String originAccountTerminalUn) {
    this.originAccountTerminalUn = originAccountTerminalUn;
  }

  @JsonIgnore
  public DeviceQueryInfo companyInfo(CompanyQueryInfo companyInfo) {
    this.companyInfo = companyInfo;
    return this;
  }

   /**
   * 公司信息
   * @return companyInfo
  **/

  @Valid

  @ApiModelProperty(value = "公司信息")
  public CompanyQueryInfo getCompanyInfo() {
    return companyInfo;
  }

  public void setCompanyInfo(CompanyQueryInfo companyInfo) {
    this.companyInfo = companyInfo;
  }

  @JsonIgnore
  public DeviceQueryInfo deviceNo(String deviceNo) {
    this.deviceNo = deviceNo;
    return this;
  }

   /**
   * 设备编号
   * @return deviceNo
  **/


  @ApiModelProperty(value = "设备编号")
  public String getDeviceNo() {
    return deviceNo;
  }

  public void setDeviceNo(String deviceNo) {
    this.deviceNo = deviceNo;
  }

  @JsonIgnore
  public DeviceQueryInfo deviceName(String deviceName) {
    this.deviceName = deviceName;
    return this;
  }

   /**
   * 设备名称
   * @return deviceName
  **/


  @ApiModelProperty(value = "设备名称")
  public String getDeviceName() {
    return deviceName;
  }

  public void setDeviceName(String deviceName) {
    this.deviceName = deviceName;
  }

  @JsonIgnore
  public DeviceQueryInfo supportService(List<String> supportService) {
    this.supportService = supportService;
    return this;
  }

  public DeviceQueryInfo addSupportServiceItem(String supportServiceItem) {
    this.supportService.add(supportServiceItem);
    return this;
  }

   /**
   * 支持的服务（print:打印 make:开票,originAccount:底账,assistant：辅助）
   * @return supportService
  **/


  @ApiModelProperty(value = "支持的服务（print:打印 make:开票,originAccount:底账,assistant：辅助）")
  public List<String> getSupportService() {
    return supportService;
  }

  public void setSupportService(List<String> supportService) {
    this.supportService = supportService;
  }

  @JsonIgnore
  public DeviceQueryInfo status(List<Integer> status) {
    this.status = status;
    return this;
  }

  public DeviceQueryInfo addStatusItem(Integer statusItem) {
    this.status.add(statusItem);
    return this;
  }

   /**
   * 设备状态（0：待审核 1:审核通过  2：审核失败  11：启用 12：未启用 21：关闭）
   * @return status
  **/


  @ApiModelProperty(value = "设备状态（0：待审核 1:审核通过  2：审核失败  11：启用 12：未启用 21：关闭）")
  public List<Integer> getStatus() {
    return status;
  }

  public void setStatus(List<Integer> status) {
    this.status = status;
  }

  @JsonIgnore
  public DeviceQueryInfo taxDeviceInfo(TaxDeviceQueryRequestInfo taxDeviceInfo) {
    this.taxDeviceInfo = taxDeviceInfo;
    return this;
  }

   /**
   * 税控设备消息
   * @return taxDeviceInfo
  **/

  @Valid

  @ApiModelProperty(value = "税控设备消息")
  public TaxDeviceQueryRequestInfo getTaxDeviceInfo() {
    return taxDeviceInfo;
  }

  public void setTaxDeviceInfo(TaxDeviceQueryRequestInfo taxDeviceInfo) {
    this.taxDeviceInfo = taxDeviceInfo;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DeviceQueryInfo deviceQueryInfo = (DeviceQueryInfo) o;
    return Objects.equals(this.deviceType, deviceQueryInfo.deviceType) &&
        Objects.equals(this.deviceTypeList, deviceQueryInfo.deviceTypeList) &&
        Objects.equals(this.deviceIds, deviceQueryInfo.deviceIds) &&
        Objects.equals(this.deviceUns, deviceQueryInfo.deviceUns) &&
        Objects.equals(this.originAccountTerminalId, deviceQueryInfo.originAccountTerminalId) &&
        Objects.equals(this.originAccountTerminalUn, deviceQueryInfo.originAccountTerminalUn) &&
        Objects.equals(this.companyInfo, deviceQueryInfo.companyInfo) &&
        Objects.equals(this.deviceNo, deviceQueryInfo.deviceNo) &&
        Objects.equals(this.deviceName, deviceQueryInfo.deviceName) &&
        Objects.equals(this.supportService, deviceQueryInfo.supportService) &&
        Objects.equals(this.status, deviceQueryInfo.status) &&
        Objects.equals(this.taxDeviceInfo, deviceQueryInfo.taxDeviceInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(deviceType, deviceTypeList, deviceIds, deviceUns, originAccountTerminalId, originAccountTerminalUn, companyInfo, deviceNo, deviceName, supportService, status, taxDeviceInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DeviceQueryInfo {\n");

    sb.append("    deviceType: ").append(toIndentedString(deviceType)).append("\n");
    sb.append("    deviceTypeList: ").append(toIndentedString(deviceTypeList)).append("\n");
    sb.append("    deviceIds: ").append(toIndentedString(deviceIds)).append("\n");
    sb.append("    deviceUns: ").append(toIndentedString(deviceUns)).append("\n");
    sb.append("    originAccountTerminalId: ").append(toIndentedString(originAccountTerminalId)).append("\n");
    sb.append("    originAccountTerminalUn: ").append(toIndentedString(originAccountTerminalUn)).append("\n");
    sb.append("    companyInfo: ").append(toIndentedString(companyInfo)).append("\n");
    sb.append("    deviceNo: ").append(toIndentedString(deviceNo)).append("\n");
    sb.append("    deviceName: ").append(toIndentedString(deviceName)).append("\n");
    sb.append("    supportService: ").append(toIndentedString(supportService)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    taxDeviceInfo: ").append(toIndentedString(taxDeviceInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
