package com.xforceplus.ant.coop.rule.center.client.data.enterprise.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.Valid;
import java.io.Serializable;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * RuleCenterQueryDeviceRequest
 */

@JsonInclude(NON_NULL)
public class RuleCenterQueryDeviceRequest implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("queryInfo")
  private DeviceQueryInfo queryInfo = null;

  @JsonProperty("pageInfo")
  private PageInfo pageInfo = null;

  @JsonProperty("sortInfo")
  private DeviceSortInfo sortInfo = null;

  @JsonProperty("queryServiceState")
  private Boolean queryServiceState = null;

  @JsonProperty("queryOriginAccountServiceState")
  private Boolean queryOriginAccountServiceState = false;




  @JsonIgnore
  public RuleCenterQueryDeviceRequest queryInfo(DeviceQueryInfo queryInfo) {
    this.queryInfo = queryInfo;
    return this;
  }

   /**
   * （必填）查询信息
   * @return queryInfo
  **/

  @Valid

  @ApiModelProperty(value = "（必填）查询信息")
  public DeviceQueryInfo getQueryInfo() {
    return queryInfo;
  }

  public void setQueryInfo(DeviceQueryInfo queryInfo) {
    this.queryInfo = queryInfo;
  }

  @JsonIgnore
  public RuleCenterQueryDeviceRequest pageInfo(PageInfo pageInfo) {
    this.pageInfo = pageInfo;
    return this;
  }

   /**
   * 分页信息
   * @return pageInfo
  **/

  @Valid

  @ApiModelProperty(value = "分页信息")
  public PageInfo getPageInfo() {
    return pageInfo;
  }

  public void setPageInfo(PageInfo pageInfo) {
    this.pageInfo = pageInfo;
  }

  @JsonIgnore
  public RuleCenterQueryDeviceRequest sortInfo(DeviceSortInfo sortInfo) {
    this.sortInfo = sortInfo;
    return this;
  }

   /**
   * 排序信息
   * @return sortInfo
  **/

  @Valid

  @ApiModelProperty(value = "排序信息")
  public DeviceSortInfo getSortInfo() {
    return sortInfo;
  }

  public void setSortInfo(DeviceSortInfo sortInfo) {
    this.sortInfo = sortInfo;
  }

  @JsonIgnore
  public RuleCenterQueryDeviceRequest queryServiceState(Boolean queryServiceState) {
    this.queryServiceState = queryServiceState;
    return this;
  }

   /**
   * 查询直连在线状态（注意：此字段不会进入条件筛选，只会在满足上述条件后进行额外的在线情况获取）
   * @return queryServiceState
  **/


  @ApiModelProperty(value = "查询直连在线状态（注意：此字段不会进入条件筛选，只会在满足上述条件后进行额外的在线情况获取）")
  public Boolean QueryServiceState() {
    return queryServiceState;
  }

  public void setQueryServiceState(Boolean queryServiceState) {
    this.queryServiceState = queryServiceState;
  }

  @JsonIgnore
  public RuleCenterQueryDeviceRequest queryOriginAccountServiceState(Boolean queryOriginAccountServiceState) {
    this.queryOriginAccountServiceState = queryOriginAccountServiceState;
    return this;
  }

   /**
   * 查询底账在线状态（注意：此字段不会进入条件筛选，只会在满足上述条件后进行额外的在线情况获取）
   * @return queryOriginAccountServiceState
  **/


  @ApiModelProperty(value = "查询底账在线状态（注意：此字段不会进入条件筛选，只会在满足上述条件后进行额外的在线情况获取）")
  public Boolean QueryOriginAccountServiceState() {
    return queryOriginAccountServiceState;
  }

  public void setQueryOriginAccountServiceState(Boolean queryOriginAccountServiceState) {
    this.queryOriginAccountServiceState = queryOriginAccountServiceState;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RuleCenterQueryDeviceRequest queryDeviceRequest = (RuleCenterQueryDeviceRequest) o;
    return Objects.equals(this.queryInfo, queryDeviceRequest.queryInfo) &&
        Objects.equals(this.pageInfo, queryDeviceRequest.pageInfo) &&
        Objects.equals(this.sortInfo, queryDeviceRequest.sortInfo) &&
        Objects.equals(this.queryServiceState, queryDeviceRequest.queryServiceState) &&
        Objects.equals(this.queryOriginAccountServiceState, queryDeviceRequest.queryOriginAccountServiceState);
  }

  @Override
  public int hashCode() {
    return Objects.hash(queryInfo, pageInfo, sortInfo, queryServiceState, queryOriginAccountServiceState);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RuleCenterQueryDeviceRequest {\n");

    sb.append("    queryInfo: ").append(toIndentedString(queryInfo)).append("\n");
    sb.append("    pageInfo: ").append(toIndentedString(pageInfo)).append("\n");
    sb.append("    sortInfo: ").append(toIndentedString(sortInfo)).append("\n");
    sb.append("    queryServiceState: ").append(toIndentedString(queryServiceState)).append("\n");
    sb.append("    queryOriginAccountServiceState: ").append(toIndentedString(queryOriginAccountServiceState)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
