package com.xforceplus.ant.coop.rule.center.client.data.log.enums;

import java.util.Arrays;

/**
 * Describe: OperateLogTypeEnum
 *
 * @Author xiezhongyong
 * @Date 2021-12-20
 */
public enum OperateLogTypeEnum {
    BASE_CONFIG("BASE_CONFIG", "基础配置"),
    ;

    private final String code;
    private final String message;

    OperateLogTypeEnum(String code, String message) {
        this.code = code;
        this.message = message;
    }

    public String code() {
        return code;
    }

    public String message() {
        return message;
    }

    public static OperateLogTypeEnum fromValue(String code) {
        return Arrays.stream(OperateLogTypeEnum.values())
                .filter(s -> s.code.equals(code))
                .findAny()
                .orElse(null);
    }

}
