package com.xforceplus.ant.coop.rule.center.client.data.sc.group;

import com.xforceplus.ant.coop.rule.center.client.data.cc.bean.limiters.Conditions;
import com.xforceplus.ant.coop.rule.center.client.data.sc.groupitem.ListConfigGroupItem;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * Describe: 配置分组响应
 *
 * @Author xiezhongyong
 * @String 2022-05-10
 */
@Data
public class GetConfigGroup {

    @ApiModelProperty("数据ID")
    private String id;

    @ApiModelProperty("父分组ID")
    private String parentGroupId;

    @ApiModelProperty("分组名称")
    private String groupName;

    @ApiModelProperty("分组描述")
    private String groupDesc;

    @ApiModelProperty("分组类型;1-字段配置 2-功能配置")
    private Integer groupType;

    @ApiModelProperty("引用字段分组ID(只有功能配置才有")
    private String refGroupId;

    @ApiModelProperty("菜单ID")
    private String menuId;

    @ApiModelProperty("协同配置ID")
    private String coopConfigId;

    @ApiModelProperty("配置方ID")
    private String configObjId;

    @ApiModelProperty("单据类型ID")
    private String billTypeId;

    @ApiModelProperty("单据类型开关;1-支持配置 0-不支持配置")
    private Integer billTypeActive;

    @ApiModelProperty("编辑标记;0-可以编辑和删除 1-可编辑,不能删除 2-不可编辑,可以删除 3-不可编辑和删除")
    private Integer editFlag;

    @ApiModelProperty("继承标识;0-不允许继承 1-允许单继承(默认) 2-允许多继承")
    private Integer extendsFlag;

    @ApiModelProperty("通用配置标记;0-否(默认) 1-是")
    private Integer commonFlag;

    @ApiModelProperty("状态;1-启用(默认)  0-停用")
    private Integer status;

    @ApiModelProperty("创建人")
    private String createUser;

    @ApiModelProperty("创建人姓名")
    private String createUserName;

    @ApiModelProperty("创建时间")
    private String createTime;

    @ApiModelProperty("更新人")
    private String updateUser;

    @ApiModelProperty("更新人姓名")
    private String updateUserName;

    @ApiModelProperty("更新时间")
    private String updateTime;

    @ApiModelProperty("限定条件")
    private Conditions limiters;

    @ApiModelProperty("适用范围;0-通用 1-限定条件")
    private Integer applyRange;

    @ApiModelProperty("限定条件开关;1-支持配置 0-不支持配置")
    private Integer limitersActive;

    @ApiModelProperty("限定条件MD5")
    private String limitersMd5;

    @ApiModelProperty("限定条件表达式")
    private String limitersExp;

    @ApiModelProperty("配置分组明细列表")
    private List<ListConfigGroupItem> itemList;

}
