package com.xforceplus.ant.coop.rule.center.client.data.sc.groupitem;

import com.xforceplus.ant.coop.rule.center.client.data.cc.response.GetBizConfig;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * Describe: 分组明细 列表
 *
 * @Author xiezhongyong
 * @Date 2022-05-11
 */
@Data
public class ListConfigGroupItem {

    @ApiModelProperty("数据ID")
    private String id;

    @ApiModelProperty("分组ID")
    private String groupId;

    @ApiModelProperty("父分组明细ID")
    private String parentGroupItemId;

    @ApiModelProperty("配置类型(DATA_TEMPLATE:数据模板;RULE_TEMPLATE:数据规则,BIZ_CONFIG:业务配置)")
    private String configType;

    @ApiModelProperty("配置ID(通过配置ID 可以读取对应的数据模板/数据规则/业务配置，如果配置ID为空时说明是一个只读配置,并且没有匹配到对应的配置)")
    private String configId;

    @ApiModelProperty("配置父ID")
    private String configPanertId;

    @ApiModelProperty("配置modelType")
    private Integer configModelType;

    @ApiModelProperty("协同配置ID")
    private String coopConfigId;

    @ApiModelProperty("配置方ID")
    private String configObjId;

    @ApiModelProperty("单据类型ID")
    private String billTypeId;

    @ApiModelProperty("通用配置标记;0-否(默认) 1-是")
    private Integer commonFlag;

    @ApiModelProperty("配置来源;0-业务配置触发新建 1-规则中心存在关联")
    private Integer configSource;

    @ApiModelProperty("配置名称")
    private String configName;

    @ApiModelProperty("配置描述")
    private String configDesc;

    @ApiModelProperty("只读标识;0-非只读(默认) 1-只读 ps: 只读情况下可以通过configId 读取不到规则配置,读取不到情况下按产品需求显示描述")
    private Integer readonlyState;

    @ApiModelProperty("只读描述")
    private String readonlyDesc;

    @ApiModelProperty("排序")
    private Integer sort;

    @ApiModelProperty("业务配置响应(业务配置-基础开关配置-才会有返回)")
    private GetBizConfig bizConfig;
}
