package com.xforceplus.ant.coop.rule.center.client.data.sc.menu;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;

/**
 * Describe: 配置方菜单保存
 *
 * @Author xiezhongyong
 * @Date 2022-05-05
 */
@Data
public class SaveMenuConfig {

    @ApiModelProperty("协同购方配置ID")
    @NotNull(message = "协同购方配置ID 不能为空")
    private Long coopConfigId;

    @ApiModelProperty("菜单ID列表")
    @NotNull(message = "菜单ID列表 不能为空")
    @Size(min = 1, max = 100, message = "菜单ID列表范围[1-100]")
    private List<Long> menuIds;
}
