package com.xforceplus.ant.coop.rule.center.client.data.utils;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author gaosheng
 * Created on 2022/6/30
 */
@ApiModel(description = "返回体")
@Data
public class BaseResponse<T> implements Serializable {
    /**
     * 返回结果状态码
     */
    @ApiModelProperty("状态码 1-成功 其它-失败")
    private String code;

    /**
     * 返回提示信息
     */
    @ApiModelProperty("提示信息")
    private String message;

    /**
     * 返回成功数据
     */
    @ApiModelProperty("响应数据")
    private T result;

    private static final String SUCCESS_CODE = "1";
    private static final String DEFAULT_FAIL_CODE = "0";
    private static final String SUCCESS_MSG = "success";

    private BaseResponse(String code, String message, T result) {
        this.code = code;
        this.message = message;
        this.result = result;
    }

    private BaseResponse(T result) {
        this(SUCCESS_CODE, SUCCESS_MSG, result);
    }

    public static <T> BaseResponse<T> success(T result) {
        return new BaseResponse<T>(result);
    }

    public static <T> BaseResponse<T> fail(String code, String message) {
        if (SUCCESS_CODE.equals(code)) {
            throw new RuntimeException("错误码异常，1表示成功");
        }
        return new BaseResponse<T>(code, message, null);
    }

    public static <T> BaseResponse<T> fail(String message) {
        return fail(DEFAULT_FAIL_CODE, message);
    }
}
