package com.xforceplus.ant.coop.rule.center.client.data.utils;

import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.xforceplus.ant.coop.rule.center.client.data.cc.bizconfig.enums.IEnum;

import java.io.IOException;
import java.lang.reflect.Type;

/**
 * Describe: IEnumConvert
 *
 * @Author xiezhongyong
 * @Date 2022-04-13
 */
public class IEnumConvert implements ObjectSerializer, ObjectDeserializer {
    /**
     * 反序列化过程
     *
     * @param parser
     * @param type
     * @param fieldName
     * @param <T>
     * @return
     */
    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type type, Object fieldName) {
        Object value = parser.parse();
        if (null == value) {
            return null;
        }
        Class<? extends IEnum> classe = (Class<? extends IEnum>) type;
        IEnum[] enumConstants = classe.getEnumConstants();
        for (IEnum enumConstant : enumConstants) {
            if (enumConstant.code().equals(value)) {
                return (T) enumConstant;
            }
        }
        return null;
    }

    @Override
    public int getFastMatchToken() {
        return 0;
    }


    @Override
    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) throws IOException {
        Object code = ((IEnum) object).code();
        serializer.write(code);
    }
}